% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{fastJaccardEVs}
\alias{fastJaccardEVs}
\title{Computation of the k leading eigenvectors of the Jaccard similarity matrix for a (sparse) input matrix. Note that this computation is only approximate and does not necessarily coincide with the result obtained by extracting the k leading eigenvectors of the Jaccard matrix computed with the function \code{jaccardMatrix}.}
\usage{
fastJaccardEVs(m, k, useCpp = TRUE, sparse = TRUE, q = 2)
}
\arguments{
\item{m}{A (sparse) matrix for which the eigenvectors of its Jaccard matrix are sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{k}{The number of leading eigenvectors.}

\item{useCpp}{Flag to switch between R or C++ implementations. Default is \code{useCpp=TRUE}.}

\item{sparse}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{sparse=TRUE}.}

\item{q}{The number of power iteration steps (default is \code{q=2}).}
}
\value{
The k leading eigenvectors of the Jaccard matrix of \code{m} as a column matrix.
}
\description{
Computation of the k leading eigenvectors of the Jaccard similarity matrix for a (sparse) input matrix. Note that this computation is only approximate and does not necessarily coincide with the result obtained by extracting the k leading eigenvectors of the Jaccard matrix computed with the function \code{jaccardMatrix}.
}
\examples{
library(locStra)
library(Matrix)
m <- matrix(sample(0:1,100,replace=TRUE),ncol=5)
sparseM <- Matrix(m,sparse=TRUE)
print(fastJaccardEVs(sparseM,k=2))

}
\references{
Dmitry Prokopenko, Julian Hecker, Edwin Silverman, Marcello Pagano, Markus Noethen, Christian Dina, Christoph Lange and Heide Fier (2016). Utilizing the Jaccard index to reveal population stratification in sequencing data: a simulation study and an application to the 1000 Genomes Project. Bioinformatics, 32(9):1366-1372.

N. Halko, P.G. Martinsson, and J.A. Tropp (2011). Finding Structure with Randomness: Probabilistic Algorithms for Constructing Approximate Matrix Decompositions. SIAM Review: 53(2), pp. 217--288.
}
