% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{transmatrix2sequence}
\alias{transmatrix2sequence}
\title{Sampling function for Markov chains}
\usage{
transmatrix2sequence(matrix, length, initialIndex, score)
}
\arguments{
\item{matrix}{transition matrix of Markov process}

\item{length}{length of sequence to be sampled}

\item{initialIndex}{(optional) index of matrix which should be initial value of sequence. If none supplied, a value from the stationary distribution is sampled as initial value.}

\item{score}{(optional) a vector representing the scores (in ascending order) of the matrix index. If supplied, the result will be a vector of these values.}
}
\value{
a Markov chain sampled from the transition matrix
}
\description{
Creates Markov chains based on a transition matrix. Can be used as parameter for the Monte Carlo function.
}
\details{
The transition matrix is considered representing the transition from one score to another such that the score in the first row is the lowest 
and the last row are the transitions from the highest score to another. The matrix must be stochastic (no rows filled up with only '0' values).
}
\examples{
B = t(matrix (c(0.2, 0.8, 0.4, 0.6), nrow = 2))
transmatrix2sequence(B, length = 10)
MyTransMat <-
   matrix(c(0.3,0.1,0.1,0.1,0.4, 0.2,0.2,0.1,0.2,0.3, 0.3,0.4,0.1,0.1,0.1, 0.3,0.3,0.1,0.0,0.3,
    0.1,0.1,0.2,0.3,0.3), ncol = 5, byrow=TRUE)
MySeq.CM=transmatrix2sequence(matrix = MyTransMat,length=90, score =c(-2,-1,0,2,3))
MySeq.CM
}
