% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{recordTimes}
\alias{recordTimes}
\title{Calculate the record times of a sequence}
\usage{
recordTimes(sequence)
}
\arguments{
\item{sequence}{numeric sequence of a Lindley process, eg service time per
customer}
}
\value{
a vector with the record times. If no record time are found, return
  empty vector \code{integer(0)}
}
\description{
For a given sequence of real numbers, this function returns the
  index of the values where Lindley/CUSUM process are <0
}
\details{
Note that the first record times which is always 0 is not included
in the returned vector
}
\examples{
####This example should return this vector: c(1,3,4,5,10)
seq1 <- c(-1,2,-2.00001,-4,-1,3,-1,-2,3,-4,2)
recordTimes(seq1)
####This example should return integer(0) because there is no record times in this sequence
seq2 <- c(4,1,0,-1,-2,5,-5,0,4)
recordTimes(seq2)
}
