% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_layers.R
\name{set_layers}
\alias{set_layers}
\title{Set up a column of multiple plots}
\usage{
set_layers(n = 1, heights = c(rep(3, n), 2), rev = FALSE)
}
\arguments{
\item{n}{Number of plots (not including gene tracks on bottom)}

\item{heights}{Vector of length \code{nrow + 1} specifying height for plots with
a gene track on the bottom}

\item{rev}{Logical whether to reverse plotting order and plot from bottom to
top}
}
\value{
Sets \code{\link[=layout]{layout()}} to enable multiple plots aligned in a column. The
gene track is assumed to be positioned on the bottom. Returns \code{par()}
invisibly so that layout can be reset to default at the end of plotting.
}
\description{
Uses \code{\link[=layout]{layout()}} to set up multiple locus plots aligned in a column.
}
\seealso{
\code{\link[=layout]{layout()}}
}
