% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_eqtl.R
\name{link_eqtl}
\alias{link_eqtl}
\title{Obtain GTEx eQTL data via LDlinkR}
\usage{
link_eqtl(loc, pop = "CEU", r2d = "r2", token = "", ...)
}
\arguments{
\item{loc}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}}

\item{pop}{A 1000 Genomes Project population, (e.g. YRI or CEU), multiple
allowed, default = "CEU". Passed to \code{LDlinkR::LDexpress()}.}

\item{r2d}{Either "r2" for LD r^2 or "d" for LD D', default = "r2". Passed
to \code{LDlinkR::LDexpress()}.}

\item{token}{Personal access token for accessing 1000 Genomes LD data via
LDlink API. See \code{LDlinkR} package documentation.}

\item{...}{Optional arguments such as \code{genome_build} which are passed on to
\code{LDlinkR::LDexpress()}}
}
\value{
Returns an object of class 'locus' with an extra list element 'LDexp'
containing a dataframe of information obtained via \code{LDexpress()}.
}
\description{
Adds eQTL (expression quantitative trait loci) information from GTEx
(https://gtexportal.org/) to a 'locus' class object. It queries LDlink
(https://ldlink.nci.nih.gov/) via the \code{LDlinkR} package to retrieve GTEx eQTL
information on a reference SNP.
}
\details{
The additional eQTL information obtained from LDlink web server can be
displayed using \code{\link[=eqtl_plot]{eqtl_plot()}} which generates a scatter plot with gene tracks
similar to a locus plot, or with \code{\link[=overlay_plot]{overlay_plot()}} which tries to overlay the
EQTL analysis over the original locus results (e.g. GWAS).
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=eqtl_plot]{eqtl_plot()}} \code{\link[=overlay_plot]{overlay_plot()}}
}
