% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logKDE.R
\name{bw.logCV}
\alias{bw.logCV}
\title{Optimal CV BW estimation for strictly positive distributions.}
\usage{
bw.logCV(x, grid = 21, NB = 512)
}
\arguments{
\item{x}{numeric vector of the data. Must be strictly positive, will be log transformed during estimation.}

\item{grid}{number of points used for BW selection CV grid.}

\item{NB}{number of points at which to estimate the KDE at during the CV loop.}
}
\value{
bw the optimal least squares CV bandwidth.
}
\description{
Computes least squares cross-validation (CV) bandwidth (BW) for log domain KDE.
}
\examples{
bw.logCV(rchisq(100,10), grid=21, NB=512)

}
