% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{stopifnot}
\alias{stopifnot}
\title{Conditional Stop Function Log Handler}
\usage{
stopifnot(..., exprObject, local, .loggit = TRUE, echo = TRUE)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or (for
    \code{message} only) a single condition object.}

\item{exprObject}{alternative to \code{exprs} or \code{...}:
    an \sQuote{expression-like} object, typically an
    \code{\link[base]{expression}}, but also a \code{\link[base]{call}}, a
    \code{\link[base]{name}}, or atomic constant such as \code{TRUE}.
  }

\item{local}{(only when \code{exprs} is used:) indicates the
    \code{\link[base]{environment}} in which the expressions should be
    evaluated; by default the one from where \code{stopifnot()} has been
    called.}

\item{.loggit}{Should \code{loggit()} execute? Defaults to \code{TRUE}.}

\item{echo}{Should \code{loggit()}'s log entry be echoed to the console, as well? Defaults to \code{TRUE}.}
}
\value{
(\code{\link[base]{NULL}} if all statements in \code{\dots} are \code{TRUE}.)
}
\description{
This function is identical to base R's \code{\link[base:stopifnot]{stopifnot}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
  stopifnot("This is a completely false condition, which throws an error" = TRUE)

}
\seealso{
Other handlers: 
\code{\link{message}()},
\code{\link{stop}()},
\code{\link{warning}()}
}
\concept{handlers}
