% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fitted.logitr}
\alias{fitted.logitr}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{logitr}(object, probs = NULL, ...)
}
\arguments{
\item{object}{is an object of class \code{logitr} (a model estimated using
the 'logitr()` function).}

\item{probs}{Predicted probabilities for an object of class \code{logitr} to use
in computing fitted values Defaults to \code{NULL}.}

\item{...}{further arguments.}
}
\value{
A data frame of the \code{obsID} and the fitted values extracted from
\code{object}.
}
\description{
Returns fitted values from an object of class \code{logitr}.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Extract the fitted values from the model
fitted(mnl_pref)
}
\keyword{fitted}
\keyword{fitted.values}
\keyword{logitr}
