% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrp.R
\name{lrp}
\alias{lrp}
\title{Longitudinal Recursive Partitioning}
\usage{
lrp(method, nlme.model = NULL, randomFormula, fixedFormula = NULL, data,
  start, group, rPartFormula, weight = NULL, R = NULL, min.dev = NULL,
  control = rpart.control())
}
\arguments{
\item{method}{Whether to use lme() or nlme(). Use either method="lme" or method="nlme".
This changes what additional arguments need to be passed.}

\item{nlme.model}{Necessary to specify if method="nlme"}

\item{randomFormula}{Random effects to include for nlme() or lme()}

\item{fixedFormula}{Fixed effects to include for nlme() or lme()}

\item{data}{Dataset}

\item{start}{Starting values for nlme()}

\item{group}{Grouping for nlme()}

\item{rPartFormula}{Not sure yet}

\item{weight}{Sample weights to be passed to rpart}

\item{R}{Correlation matrix to use for nlme. this is correlation=}

\item{min.dev}{The minimum decrease in deviance to choose a split.
Note that this overrides the default cp criterion in
rpart.control()}

\item{control}{Control function to be passed to rpart()}
}
\description{
Longitudinal Recursive Partitioning
}
\examples{
library(longRPart2)

\donttest{
data(ex.data.3)
model.0 = nlme(y~b0i+b1i*time,
               data=ex.data.3,
               fixed=b0i+b1i~1,
               random=b0i+b1i~1,
               group=~id,
               start=c(10,5))


lcart.mod1 <- lrp(method="nlme",
                 nlme.model=y~b0i+b1i*time,
                 fixedFormula=b0i+b1i~1,
                 rPartFormula = ~ z,
                 group= ~ id,
                 randomFormula=b0i+b1i~1,
                 data=ex.data.3,
                 start=c(10,5))
}
data(lcart.mod1)
summary(lcart.mod1)
plot(lcart.mod1)
lrp2Plot(lcart.mod1)

}
\keyword{effects}
\keyword{longitudinal}
\keyword{mixed}
\keyword{partitioning}
\keyword{recursive}
