% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric.R
\name{fit_elife}
\alias{fit_elife}
\title{Fit excess lifetime models by maximum likelihood}
\usage{
fit_elife(
  time,
  time2 = NULL,
  event = NULL,
  type = c("right", "left", "interval", "interval2"),
  ltrunc = NULL,
  rtrunc = NULL,
  thresh = 0,
  status = NULL,
  family = c("exp", "gp", "weibull", "gomp", "gompmake", "extgp", "gppiece",
    "extweibull", "perks", "perksmake", "beard", "beardmake"),
  weights = NULL,
  export = FALSE,
  start = NULL,
  restart = FALSE,
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{thresh}{vector of thresholds}

\item{status}{integer vector giving status of an observation. If \code{NULL} (default), this argument is computed internally based on \code{type}.}

\item{family}{string; choice of parametric family}

\item{weights}{weights for observations}

\item{export}{logical; should data be included in the returned object to produce diagnostic plots? Default to \code{FALSE}.}

\item{start}{vector of starting values for the optimization routine. If \code{NULL}, the algorithm attempts to find default values and returns a warning with
false convergence diagnostic if it cannot.}

\item{restart}{logical; should multiple starting values be attempted? Default to \code{FALSE}.}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional parameters, currently ignored}
}
\value{
an object of class \code{elife_par}
}
\description{
This function is a wrapper around constrained optimization
routines for different models with non-informative
censoring and truncation patterns.
}
\note{
The extended generalized Pareto model is constrained
to avoid regions where the likelihood is flat so \eqn{\xi \in [-1, 10]} in
the optimization algorithm.

The standard errors are obtained via the observed information matrix, calculated
using the hessian. In many instances, such as when the shape parameter is zero
or negative, the hessian is singular and no estimates are returned.
}
\examples{
data(ewsim, package = "longevity")
fit1 <- fit_elife(
   arguments = ewsim,
   export = TRUE,
   family = "exp")
fit2 <- fit_elife(
   arguments = ewsim,
   export = TRUE,
   family = "gp")
plot(fit1)
summary(fit1)
anova(fit2, fit1)
}
