% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vqsresub.R
\name{vqsresub}
\alias{vqsresub}
\title{Computing viral quasispecies diversity metrics of error-minimized repeatedly down-sampled read alignments}
\arguments{
\item{fasta}{Input as a read alignment in FASTA format}

\item{iter}{Number of iterations for downsampling after error minimization.}

\item{method}{Sequencing error minimization methods that replace low frequency nucleotide base (less than the "pct" cut-off) with consensus base of that position ("conbase": default) or with base of the dominant haplotype ("domhapbase").}

\item{pct}{Percent cut-off defining low frequency nucleotide base that will be replaced (must be specified).}

\item{gappct}{The percent cut-off particularly specified for gap (-). If it is not specified or less than "pct", "gappct" will be equal to "pct" (default).}

\item{ignoregappositions}{Replace all nucleotides in the positions in the alignment containing gap(s) with gap. This will make such positions no longer single nucleotide variant (SNV). The default is "FALSE".}

\item{samsize}{Sample size (number of reads) after down-sampling. If it is not specified or more than number of reads in the original alignment, down-sampling will not be performed (default).}

\item{label}{String within quotation marks indicating name of read alignment (optional).}
}
\value{
Data frame containing all viral quasispecies diversity metrics calculated by QSutils package, error minimization, and down-sampling information per each downsampling iteration.
}
\description{
Minimizes potential long-read sequencing error based on the specified cut-off percentage of low frequency nucleotide base and repeatedly down-samples read for sensitivity analysis of the diversity metrics varied by different sample sizes. The output of this function is a summary of viral quasispecies diversity metrics per each iteration of down-sampling calculated by QSutils package's functions. This function is an extension of "vqssub" function.
}
\examples{
## Locate input FASTA file-------------------------------------------------------------------------
fastafilepath <- system.file("extdata", "s1.fasta", package = "longreadvqs")

## Summarize viral quasispecies diversity metrics from five downsampling iterations.---------------
vqsresub(fastafilepath, iter = 5, pct = 10, samsize = 20, label = "sample1")

}
