% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_moment_matching.R
\name{loo_moment_match_split}
\alias{loo_moment_match_split}
\title{Split moment matching for efficient approximate leave-one-out cross-validation (LOO)}
\usage{
loo_moment_match_split(
  x,
  upars,
  cov,
  total_shift,
  total_scaling,
  total_mapping,
  i,
  log_prob_upars,
  log_lik_i_upars,
  r_eff_i,
  cores,
  is_method,
  ...
)
}
\arguments{
\item{x}{A fitted model object.}

\item{upars}{A matrix containing the model parameters in unconstrained space
where they can have any real value.}

\item{cov}{Logical; Indicate whether to match the covariance matrix of the
samples or not. If \code{FALSE}, only the mean and marginal variances are
matched.}

\item{total_shift}{A vector representing the total shift made by the moment
matching algorithm.}

\item{total_scaling}{A vector representing the total scaling of marginal
variance made by the moment matching algorithm.}

\item{total_mapping}{A vector representing the total covariance
transformation made by the moment matching algorithm.}

\item{i}{Observation index.}

\item{log_prob_upars}{A function that takes arguments \code{x} and \code{upars} and
returns a matrix of log-posterior density values of the unconstrained
posterior draws passed via \code{upars}.}

\item{log_lik_i_upars}{A function that takes arguments \code{x}, \code{upars}, and \code{i}
and returns a vector of log-likeliood draws of the \code{i}th observation based
on the unconstrained posterior draws passed via \code{upars}.}

\item{r_eff_i}{MCMC relative effective sample size of the \code{i}'th log
likelihood draws.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}

\item{is_method}{The importance sampling method to use. The following methods
are implemented:
\itemize{
\item \code{\link[=psis]{"psis"}}: Pareto-Smoothed Importance Sampling (PSIS). Default method.
\item \code{\link[=tis]{"tis"}}: Truncated Importance Sampling (TIS) with truncation at
\code{sqrt(S)}, where \code{S} is the number of posterior draws.
\item \code{\link[=sis]{"sis"}}: Standard Importance Sampling (SIS).
}}

\item{...}{Further arguments passed to the custom functions documented above.}
}
\value{
A list containing the updated log-importance weights and
log-likelihood values. Also returns the updated MCMC effective sample size
and the integrand-specific log-importance weights.
}
\description{
A function that computes the split moment matching importance sampling loo.
Takes in the moment matching total transformation, transforms only half
of the draws, and computes a single elpd using multiple importance sampling.
}
\references{
Paananen, T., Piironen, J., Buerkner, P.-C., Vehtari, A. (2020).
Implicitly Adaptive Importance Sampling.
\href{https://arxiv.org/abs/1906.08850}{preprint arXiv:1906.08850}
}
\seealso{
\code{\link[=loo]{loo()}}, \code{\link[=loo_moment_match]{loo_moment_match()}}
}
