% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_getChildren}
\alias{l_layer_getChildren}
\title{Get children of a group layer}
\usage{
l_layer_getChildren(widget, layer = "root")
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
Character vector with ids of the childrens. To create layer handles
  (i.e. objects of class \code{'l_layer'}) use the
  \code{\link{l_create_handle}} function.
}
\description{
Returns the ids of a group layer's children.
}
\examples{
p <- l_plot()

g <- l_layer_group(p)
l1 <- l_layer_rectangle(p, x=0:1, y=0:1, parent=g)
l2 <- l_layer_oval(p, x=0:1, y=0:1, color='thistle', parent=g)

l_layer_getChildren(p, g)
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_getParent}}
}
