% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_glyphs.R
\name{l_glyph_add_polygon}
\alias{l_glyph_add_polygon}
\title{Add a Polygon Glyph}
\usage{
l_glyph_add_polygon(widget, x, y, linewidth = 1, showArea = TRUE,
  label = "", ...)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{x}{nested list of x-coordinates of polygons (relative to ), one list element for each
scatterplot point.}

\item{y}{nested list of y-coordinates of polygons, one list element for each
scatterplot point.}

\item{linewidth}{linewidth of outline.}

\item{showArea}{boolean, show a filled polygon or just the outline}

\item{label}{label of a glyph (currently shown only in the glyph inspector)}

\item{...}{state arguments}
}
\description{
Add one polygon per scatterplot point.
}
\details{
A polygon can be a useful point glyph to visualize arbitrary shapes
  such as airplanes, animals and shapes that are not available in the
  primitive glyph types (e.g. cross). The \code{l_glyphs} demo has an example
  of polygon glyphs which we reuse here.
}
\examples{
x_star <-
    c(-0.000864304235090734, 0.292999135695765, 0.949870354364736,
      0.474503025064823, 0.586862575626621, -0.000864304235090734,
      -0.586430423509075, -0.474070872947277, -0.949438202247191,
      -0.29256698357822)
y_star <-
    c(-1, -0.403630077787381, -0.308556611927398, 0.153846153846154,
      0.808556611927398, 0.499567847882455, 0.808556611927398,
      0.153846153846154, -0.308556611927398, -0.403630077787381)
x_cross <-
    c(-0.258931143762604, -0.258931143762604, -0.950374531835206,
      -0.950374531835206, -0.258931143762604, -0.258931143762604,
      0.259651397291847, 0.259651397291847, 0.948934024776722,
      0.948934024776722, 0.259651397291847, 0.259651397291847)
y_cross <-
    c(-0.950374531835206, -0.258931143762604, -0.258931143762604,
      0.259651397291847, 0.259651397291847, 0.948934024776722,
      0.948934024776722, 0.259651397291847, 0.259651397291847,
      -0.258931143762604, -0.258931143762604, -0.950374531835206)
x_hexagon <-
    c(0.773552290406223, 0, -0.773552290406223, -0.773552290406223,
      0, 0.773552290406223)
y_hexagon <-
    c(0.446917314894843, 0.894194756554307, 0.446917314894843,
      -0.447637568424085, -0.892754249495822, -0.447637568424085)

p <- l_plot(1:3, 1:3)

gl <- l_glyph_add_polygon(p, x = list(x_star, x_cross, x_hexagon),
                          y = list(y_star, y_cross, y_hexagon))

p['glyph'] <- gl

gl['showArea'] <- FALSE
}
\seealso{
\code{\link{l_glyph_add}}

Other glyph functions: \code{\link{l_glyph_add.default}},
  \code{\link{l_glyph_add_image}},
  \code{\link{l_glyph_add_pointrange}},
  \code{\link{l_glyph_add_serialaxes}},
  \code{\link{l_glyph_add_text}},
  \code{\link{l_glyph_add}}, \code{\link{l_glyph_delete}},
  \code{\link{l_glyph_getLabel}},
  \code{\link{l_glyph_getType}}, \code{\link{l_glyph_ids}},
  \code{\link{l_glyph_relabel}},
  \code{\link{l_primitiveGlyphs}}
}
\concept{glyph functions}
