% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loonGrob.R
\name{plot.loon}
\alias{plot.loon}
\title{Plot the current view of any loon plot in the current device.}
\usage{
\method{plot}{loon}(x, y = NULL, ...)
}
\arguments{
\item{x}{the loon plot to be plotted on the current device}

\item{y}{NULL, will be ignored.}

\item{...}{parameters passed to \code{loonGrob}}
}
\value{
invisible()
}
\description{
This is a wrapper for \code{grid.loon()} to simplify the plotting of
loon plots on any device.  Frequent users are recommended to use
\code{grid.loon()} for more control.
}
\examples{

loonPlot <- with(iris, l_plot(Sepal.Length, Sepal.Width))
loonPlot['color'] <- iris$Species
loonPlot['selected'] <- iris$Species == "versicolor"
l_scaleto_selected(loonPlot)
loonPlot['showGuides'] <- TRUE
plot(loonPlot)

}
\seealso{
\code{\link{loonGrob}}, \code{\link{grid.loon}}, \code{\link{l_export}}
}
