% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bind.R
\name{l_bind_canvas}
\alias{l_bind_canvas}
\title{Create a Canvas Binding}
\usage{
l_bind_canvas(widget, event, callback)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{event}{event patterns as defined for Tk canvas widget
\url{https://www.tcl.tk/man/tcl8.6/TkCmd/bind.htm#M5}.}

\item{callback}{callback function is an R function which is called by the Tcl
interpreter if the event of interest happens. Note that in loon the 
callback functions support different optional arguments depending on the
binding type, read the details for more information}
}
\value{
canvas binding id
}
\description{
Canvas bindings are triggered by a mouse/keyboard gesture over
  the plot as a whole.
}
\details{
Canvas bindings are used to evaluate callbacks at certain X events on the
canvas widget (underlying widget for all of loon's plot widgets). Such X
events include re-sizing of the canvas and entering the canvas with the
mouse.

Bindings, callbacks, and binding substitutions are described in detail in
loon's documentation webpage, i.e. run \code{l_help("learn_R_bind")}
}
\examples{
# binding for when plot is resized
if(interactive()){
p <- l_plot(iris[,1:2], color=iris$Species)

printSize <- function(p) {
    size <- l_size(p)
    cat(paste('Size of widget ', p, ' is: ',
              size[1], 'x', size[2], ' pixels\n', sep=''))
}

l_bind_canvas(p, event='<Configure>', function(W) {printSize(W)})

id <- l_bind_canvas_ids(p)
id

l_bind_canvas_get(p, id)

}
}
\seealso{
\code{\link{l_bind_canvas_ids}}, \code{\link{l_bind_canvas_get}},
  \code{\link{l_bind_canvas_delete}}, \code{\link{l_bind_canvas_reorder}}
}
