% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_ColorList.R
\name{l_colRemoveAlpha}
\alias{l_colRemoveAlpha}
\title{Convert color representations having an alpha transparency level to 6 digit color
  representations}
\usage{
l_colRemoveAlpha(col)
}
\arguments{
\item{col}{a vector of colors (potentially) containing an alpha level}
}
\description{
Colors in the standard tk used by loon do not allow for alpha transparency.
This function allows loon to use color palettes (e.g. \code{\link{l_setColorList}}) that
produce colors with alpha transparency by simply using only the rgb.
}
\examples{
x <- l_colRemoveAlpha(rainbow(6))
# Also works with ordinary color string representations
# since it just extracts the rgb values from the colors.
x <- l_colRemoveAlpha(c("red", "blue", "green", "orange"))
x

}
