% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity.R
\name{lpdensity}
\alias{lpdensity}
\title{Local Polynomial Density Estimation and Inference}
\usage{
lpdensity(data, grid = NULL, bw = NULL, p = NULL, q = NULL,
  v = NULL, bwselect = c("mse-dpi", "imse-dpi", "mse-rot", "imse-rot"),
  kernel = c("triangular", "uniform", "epanechnikov"), Cweights = NULL,
  Pweights = NULL, scale = NULL)
}
\arguments{
\item{data}{Numeric vector or one dimensional matrix / data frame, the raw data.}

\item{grid}{Numeric vector or one dimensional matrix / data frame, the grid on which
density is estimated. When set to default, grid points will be chosen as 0.05-0.95
percentiles of the data, with 0.05 step size.}

\item{bw}{Numeric vector or one dimensional matrix / data frame, the bandwidth
used for estimation. Can be (1) a positive scalar (common
bandwidth for all grid points); or (2) a positive numeric vector specifying bandwidths for
each grid point (should be the same length as \code{grid}).}

\item{p}{Integer, nonnegative, the order of the local-polynomial used to construct point
estimates. (Default is 2.)}

\item{q}{Integer, nonnegative, the order of the local-polynomial used to construct pointwise
confidence interval (a.k.a. the bias correction order). Default is \code{p+1}. When specified
the same as \code{p}, no bias correction will be performed. Otherwise it should be
strictly larger than \code{p}.}

\item{v}{Integer, nonnegative, the derivative of distribution function to be estimated. \code{0} for
the distribution function, \code{1} (default) for the density funtion, etc.}

\item{bwselect}{String, the method for data-driven bandwidth selection. This option will be
ignored if \code{bw} is provided. Can be (1) \code{"mse-dpi"} (default, mean squared error-optimal
bandwidth selected for each grid point); or (2) \code{"imse-dpi"} (integrated MSE-optimal bandwidth,
common for all grid points); (3) \code{"mse-rot"} (rule-of-thumb bandwidth with Gaussian
reference model); and (4) \code{"imse-rot"} (integrated rule-of-thumb bandwidth with Gaussian
reference model).}

\item{kernel}{String, the kernel function, should be one of \code{"triangular"}, \code{"uniform"} or
\code{"epanechnikov"}.}

\item{Cweights, }{Numeric vector or one dimensional matrix / data frame, the weights used
for counterfactual distribution construction. Should have the same length as sample size.}

\item{Pweights}{Numeric vector or one dimensional matrix / data frame, the weights used
in sampling. Should have the same length as sample size and nonnegative.}

\item{scale}{Numeric, scaling factor for the final estimate. This parameter controls how
estimates are scaled. For example, setting this parameter to 0.5 will scale down both the
point estimates and standard errors by half. By default it is 1. This parameter is used if only
part of the sample is used for estimation, and should not be confused with \code{Cweights}
or \code{Pweights}.}
}
\value{
\item{Estimate}{A matrix containing (1) \code{grid} (grid points), (2) \code{bw} (bandwidths), (3) \code{nh}
  (effective/local sample sizes), (4) \code{f_p} (point estimates with p-th order local polynomial),
  (5) \code{f_q} (point estimates with q-th order local polynomial, only if option \code{q} is nonzero),
  (6) \code{se_p} (standard error corresponding to \code{f_p}), and (7) \code{se_q} (standard error
  corresponding to \code{f_q}).}
\item{opt}{A list containing options passed to the function.}
}
\description{
\code{lpdensity} implements the local polynomial regression based density (and derivatives)
  estimator proposed in \href{https://arxiv.org/abs/1811.11512}{Cattaneo, Jansson and Ma (2019a)}. This command can also be
  used to obtain smoothed estimates for cumulative distribution functions. See
  \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2019_lpdensity.pdf?attredirects=0}{Cattaneo, Jansson and Ma (2019b)} for more implementation details and illustrations.

  Companion command: \code{\link{lpbwdensity}} for data-driven bandwidth selection,
  and \code{\link{lpdensity.plot}} for density plot with robust confidence interval.

  For more details, and related Stata and R packages useful for empirical analysis,
  visit \url{https://sites.google.com/site/nppackages/}.
}
\examples{
set.seed(42); X <- rnorm(2000)
est1 <- lpdensity(data = X, bwselect = "imse-dpi")
summary(est1)

}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2019a). \href{https://arxiv.org/abs/1811.11512}{Simple Local Polynomial Density Estimators}. Working paper.

M. D. Cattaneo, M. Jansson and X. Ma. (2019b). \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2019_lpdensity.pdf?attredirects=0}{\code{lpdensity}: Local Polynomial Density Estimation and Inference}. Working paper.
}
\seealso{
\code{\link{lpbwdensity}} and \code{\link{lpdensity.plot}}.
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
