% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity_methods.R
\name{lpdensity.plot}
\alias{lpdensity.plot}
\title{Plot Method for Local Polynomial Density Estimation and Inference}
\usage{
lpdensity.plot(
  ...,
  alpha = NULL,
  type = NULL,
  lty = NULL,
  lwd = NULL,
  lcol = NULL,
  pty = NULL,
  pwd = NULL,
  pcol = NULL,
  grid = NULL,
  CItype = NULL,
  CIuniform = FALSE,
  CIsimul = 2000,
  CIshade = NULL,
  CIcol = NULL,
  hist = FALSE,
  histData = NULL,
  histBreaks = NULL,
  histFillCol = 3,
  histFillShade = 0.2,
  histLineCol = "white",
  title = NULL,
  xlabel = NULL,
  ylabel = NULL,
  legendTitle = NULL,
  legendGroups = NULL
)
}
\arguments{
\item{...}{Class "lpdensity" object, obtained from calling \code{\link{lpdensity}}.}

\item{alpha}{Numeric scalar between 0 and 1, specifies the significance level for plotting
confidence intervals/bands. If more than one is provided, they will be applied to each data series
accordingly.}

\item{type}{String, one of \code{"line"} (default), \code{"points"} and \code{"both"}, specifies how
the point estimates are plotted. If more than one is provided, they will be applied to each data series
accordingly.}

\item{lty}{Line type for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for solid line, \code{2} for dashed line, \code{3} for dotted line.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series accordingly.}

\item{lwd}{Line width for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. Should be strictly positive. For other options, see the instructions for
\code{\link{ggplot2}} or \code{\link{par}}. If more than one is provided, they will be applied
to each data series accordingly.}

\item{lcol}{Line color for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3} for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{pty}{Scatter plot type for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. For options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{pwd}{Scatter plot size for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. Should be strictly positive. If more than one is provided, they will be applied to each data series
accordingly.}

\item{pcol}{Scatter plot color for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{grid}{Numeric vector, specifies a subset of grid points
to plot point estimates. This option is effective only if \code{type} is \code{"points"} or
\code{"both"}; or if \code{CItype} is \code{"ebar"} or
\code{"all"}.}

\item{CItype}{String, one of \code{"region"} (shaded region, default), \code{"line"} (dashed lines),
\code{"ebar"} (error bars), \code{"all"} (all of the previous) or \code{"none"} (no confidence region),
how the confidence region should be plotted. If more than one is provided, they will be applied to each data series
accordingly.}

\item{CIuniform}{\code{TRUE} or \code{FALSE} (default), plotting either pointwise confidence intervals (\code{FALSE}) or
uniform confidence bands (\code{TRUE}).}

\item{CIsimul}{Positive integer, specifies the number of simulations used to construct critical values (default is \code{2000}). This
option is ignored if \code{CIuniform=FALSE}.}

\item{CIshade}{Numeric, specifies the opaqueness of the confidence region, should be between 0 (transparent) and
1. Default is 0.2. If more than one is provided, they will be applied to each data series
accordingly.}

\item{CIcol}{Color of the confidence region. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{hist}{\code{TRUE} or \code{FALSE} (default), specifies whether a histogram should be added to the background.}

\item{histData}{Numeric vector, specifies the data used to construct the histogram plot.}

\item{histBreaks}{Numeric vector, specifies the breakpoints between histogram cells.}

\item{histFillCol}{Color of the histogram cells.}

\item{histFillShade}{Opaqueness of the histogram cells, should be between 0 (transparent) and
1. Default is 0.2.}

\item{histLineCol}{Color of the histogram lines.}

\item{title, xlabel, ylabel}{Strings, specifies the title of the plot and labels for the x- and y-axis.}

\item{legendTitle}{String, specifies the legend title.}

\item{legendGroups}{String vector, specifies the group names used in legend.}
}
\value{
A stadnard \code{ggplot} object is returned, hence can be used for further customization.
}
\description{
This has been replaced by \code{\link{plot.lpdensity}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
