% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity_methods.R
\name{summary.lpdensity}
\alias{summary.lpdensity}
\title{Summary Method for Local Polynomial Density Estimation and Inference}
\usage{
\method{summary}{lpdensity}(object, ...)
}
\arguments{
\item{object}{Class "lpdensity" object, obtained from calling \code{\link{lpdensity}}.}

\item{...}{Additional options, including (i) \code{grid} specifies a subset of grid points
to display results; (ii) \code{gridIndex} specifies the indices of grid points
to display results; (iii) \code{alpha} specifies the significance level; (iv)
\code{CIuniform} specifies whether displaying pointwise confidence intervals (\code{FALSE}, default) or
the uniform confidence band (\code{TRUE}); (v) \code{CIsimul} specifies the number of simulations used
to construct critical values (default is \code{2000}).}
}
\description{
The summary method for local polynomial density objects.
}
\examples{
# Generate a random sample
set.seed(42); X <- rnorm(2000)

# Estimate density and report results
est1 <- lpdensity(data = X, bwselect = "imse-dpi")
summary(est1)

# Report results for a subset of grid points
summary(est1, grid=est1$Estimate[4:10, "grid"])
summary(est1, gridIndex=4:10)

# Report the 99\% uniform confidence band
set.seed(42) # fix the seed for simulating critical values
summary(est1, alpha=0.01, CIuniform=TRUE)

}
\seealso{
\code{\link{lpdensity}} for local polynomial density estimation.

Supported methods: \code{\link{coef.lpdensity}}, \code{\link{confint.lpdensity}},
  \code{\link{plot.lpdensity}}, \code{\link{print.lpdensity}}, \code{\link{summary.lpdensity}},
  \code{\link{vcov.lpdensity}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
