% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vals_switching.R
\name{get_vals_switching}
\alias{get_vals_switching}
\title{Compute values of transition function to separate regimes}
\usage{
get_vals_switching(switching_data, specs)
}
\arguments{
\item{switching_data}{A numeric vector.}

\item{specs}{A \link{list}() with inputs as in \link{lp_nl}().}
}
\value{
\item{fz}{A numeric vector with values from smooth transition function \eqn{F(z_{t-1})}.}
}
\description{
Computes transition values by using a smooth transition function as
used in Auerbach and Gorodnichenko (2012). The time series used in the transition function
can be detrended via the Hodrick-Prescott filter (see Auerbach and Gorodnichenko, 2013).
}
\references{
Auerbach, A. J., and  Gorodnichenko Y. (2012). "Measuring the Output Responses to Fiscal Policy."
\emph{American Economic Journal: Economic Policy}, 4 (2): 1-27.

Auerbach, A. J., and Gorodnichenko Y. (2013). "Fiscal Multipliers in Recession and Expansion."
\emph{NBER Working Paper Series}. Nr 17447.
}
\author{
Philipp Adämmer
}
\keyword{internal}
