% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrstat-package.R
\docType{package}
\name{lrstat-package}
\alias{lrstat-package}
\title{Power and Sample Size Calculation for Non-Proportional Hazards}
\description{
Performs power and sample size calculation for non-proportional
hazards model using the Fleming-Harrington family of weighted log-rank tests.
}
\details{
For proportional hazards, the power is determined by the total
number of events and the constant hazard ratio along with the informative
rates and the spending functions. For non-proportional hazards, the hazard
ratio varies over time and the calendar time plays a role in determining
the mean of the log-rank test statistic. It requires an iterative algorithm
to find the calendar time at which the targeted number of events will be
reached for each interim analysis. The lrstat package uses the discrete
state nonstationary Markov process method from Lakatos (1986)
and further developed in Lu (2021) to find the
mean and variance of the weighted log-rank score statistic at each interim
analysis. In addition, the package approximates the variance and covariance
matrix of the sequentially calculated log-rank test statistics under the
alternative hypothesis with that under the null hypothesis in order to
take advantage of the independent increments structure in Tsiatis (1982)
applicable for the Fleming and
Harrington family of weighted log-rank tests.

The most useful functions in the package are lrstat, lrpower, lrsamplesize,
and lrsim, which calculate the mean and variance of log-rank score
statistic at a sequence of given calendar time points, the power of the
log-rank test, the sample size in terms of accrual duration and follow-up
duration, and the log-rank test simulation, respectively. The accrual
function calculates the number of patients accrued at given calendar time
points. The caltime function finds the calendar time to reach the targeted
number of events. The exitprob function calculates the stagewise exit
probabilities for specified boundaries with a varying mean parameter over
time based on an adaptation of the recursive integration algorithm described
in Chapter 19 of Jennison and Turnbull (2000).


For critical values on the z-statistic scale, we recommend to use standard
group sequential design packages such as rpact or gsDesign as the mean
parameter is zero under the null hypothesis. However, the information
is not proportional to the number of events for weighted log-rank tests,
in which case, the caltime and lrstat functions can be used together to
find the appropriate information fractions.

With changing hazard ratio over time, the futility bounds derived
from a beta-spending function for the standard group sequential design
with a fixed parameter value cannot be used directly, in which case, the
exitprob function can be used for this purpose.

The development of the lrstat package is heavily influenced by the rpact
package. We find their function arguments to be self-explanatory due to
their names. We have used the same names whenever appropriate so that
users familiar with the rpact package can learn the lrstat package quickly.
}
\examples{
lrpower(kMax = 2, informationRates = c(0.8, 1),
        criticalValues = c(2.250, 2.025), accrualIntensity = 20,
        piecewiseSurvivalTime = c(0, 6),
        lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
        gamma1 = 0.00427, gamma2 = 0.00427,
        accrualDuration = 22, followupTime = 18)

}
\references{
Anastasios A. Tsiatis. Repeated significance testing for a general class
of statistics used in censored survival analysis. J Am Stat Assoc.
1982;77:855-861. doi:10.1080/01621459.1982.10477898

Edward Lakatos. Sample size determination in clinical trials with
time-dependent rates of losses and noncompliance. Control Clin Trials.
1986;7:189-199. doi:10.1016/0197-2456(86)90047-4

Christopher Jennison, Bruce W. Turnbull. Group Sequential Methods with
Applications to Clinical Trials. Chapman & Hall/CRC: Boca Raton, 2000,
ISBN:0849303168

Kaifeng Lu. Sample size calculation for logrank test and prediction of
number of events over time. Pharm Stat. 2021;20:229-244.
doi:10.1002/pst.2069
}
\seealso{
rpact, gsDesign
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
