% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{exitprob}
\alias{exitprob}
\title{Stagewise exit probabilities}
\usage{
exitprob(b = NA_real_, a = NA_real_, theta = NA_real_, I = NA_real_, r = 18L)
}
\arguments{
\item{b}{Upper boundaries on the z-test statistic scale.}

\item{a}{Lower boundaries on the z-test statistic scale. Defaults to
\code{c(rep(-Inf, kMax-1), b[kMax])} if left unspecified, where
\code{kMax = length(b)}.}

\item{theta}{Stagewise parameter of interest, e.g., \code{-U/V} for
weighted log-rank test, where \code{U} is the mean and \code{V} is
the variance of the weighted log-rank test score statistic at each stage.
For proportional hazards and conventional log-rank test, use the
scalar input, \code{theta = -log(HR)}.}

\item{I}{Stagewise cumulative information, e.g., \code{V}, the variance
of the weighted log-rank test score statistic at each stage. For
conventional log-rank test, information can be approximated by
\code{phi*(1-phi)*D}, where \code{phi} is the probability of being
allocated to the active arm, and \code{D} is the total number of events at
each stage.}

\item{r}{Integer value controlling grid for numerical integration as in
Jennison and Turnbull (2000). Defaults to 18. Specify a larger number
for greater accuracy.}
}
\value{
A list of stagewise exit probabilities: one vector for efficacy
stopping probabilities, and the other vector for futility stopping
probabilities.
}
\description{
Obtains the stagewise exit probabilities for both efficacy and
futility stopping.
}
\examples{
exitprob(b = c(3.471, 2.454, 2.004), theta = -log(0.6),
         I = c(50, 100, 150)/4)

}
