% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{ptpwexp}
\alias{ptpwexp}
\title{Distribution Function of Truncated Piecewise Exponential
Distribution}
\usage{
ptpwexp(
  q,
  piecewiseSurvivalTime = 0,
  lambda = 0.0578,
  lowerBound = 0,
  lower.tail = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{q}{The vector of quantiles.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates for the event. One for
each analysis time interval.}

\item{lowerBound}{The left truncation time point for the survival time.
Defaults to 0 for no truncation.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P(X <= x),
otherwise, P(X > x).}

\item{log.p}{Logical; if TRUE, probabilities p are given as log(p).}
}
\value{
The probability p such that
P(X > q | X > lowerBound) = 1 - p.
}
\description{
Obtains the probability of a truncated piecewise exponential
distribution.
}
\examples{
ptpwexp(q = c(8, 18), piecewiseSurvivalTime = c(0, 6, 9, 15),
        lambda = c(0.025, 0.04, 0.015, 0.007))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
