% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kmdiff}
\alias{kmdiff}
\title{Estimate of milestone survival difference}
\usage{
kmdiff(
  data,
  rep = "rep",
  stratum = "stratum",
  treat = "treat",
  time = "time",
  event = "event",
  milestone = NA_real_,
  survDiffH0 = 0,
  confint = 0.95
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{treat}: The treatment.
\item \code{time}: The possibly right-censored survival time.
\item \code{event}: The event indicator.
}}

\item{rep}{The name of the replication variable in the input data.}

\item{stratum}{The name of the stratum variable in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{time}{The name of the time variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{milestone}{The milestone time at which to calculate the
survival probability.}

\item{survDiffH0}{The difference in milestone survival probabilities
under the null hypothesis. Defaults to 0 for superiority test.}

\item{confint}{The level of the two-sided confidence interval for
the difference in milestone survival probabilities. Defaults to 0.95.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{rep}: The replication.
\item \code{milestone}: The milestone time relative to randomization.
\item \code{survDiffH0}: The difference in milestone survival probabilities
under the null hypothesis.
\item \code{surv1}: The estimated milestone survival probability for
the treatment group.
\item \code{surv2}: The estimated milestone survival probability for
the control group.
\item \code{survDiff}: The estimated difference in milestone survival
probabilities.
\item \code{vsurv1}: The variance for surv1.
\item \code{vsurv2}: The variance for surv2.
\item \code{vsurvDiff}: The variance for survDiff.
\item \code{survDiffZ}: The Z-statistic value.
\item \code{survDiffPValue}: The one-sided p-value.
\item \code{lower}: The lower bound of confidence interval.
\item \code{upper}: The upper bound of confidence interval.
\item \code{confint}: The level of confidence interval.
}
}
\description{
Obtains the estimate of milestone survival difference
between two treatment groups.
}
\examples{

df <- kmdiff(data = rawdata, rep = "iterationNumber",
             stratum = "stratum", treat = "treatmentGroup",
             time = "timeUnderObservation", event = "event",
             milestone = 12)
head(df)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
