% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.lsirm.R
\name{gof}
\alias{gof}
\title{Goodness-of-fit LSIRM model}
\usage{
gof(object, nsim = 500)
}
\arguments{
\item{object}{object of class \code{lsirm}.}

\item{nsim}{Integer; Number of simulation. Default is 500}
}
\value{
\code{gof} returns the boxplot or AUC plot
}
\description{
\link{gof} is goodness-of-fit the latent space of fitted LSIRM model.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5),ncol=10,nrow=50)
lsirm_result <- lsirm(data ~ lsirm1pl(spikenslab = FALSE, fixed_gamma = FALSE))
gof(lsirm_result)
}
}
