% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tz_lookup.R
\name{tz_lookup_coords}
\alias{tz_lookup_coords}
\title{Lookup time zones of lat/long pairs}
\usage{
tz_lookup_coords(lat, lon, method = "fast", warn = TRUE)
}
\arguments{
\item{lat}{numeric vector of latitudes}

\item{lon}{numeric vector of longitudes the same length as \code{x}}

\item{method}{method by which to do the lookup. Either \code{"fast"} (default)
or \code{"accurate"}.}

\item{warn}{By default, if \code{method = "fast"} a warning is issued about
the potential for inaccurate results. Set \code{warn} to \code{FALSE} to turn
this off.}
}
\value{
character vector the same length as x and y specifying the time zone of the points.
}
\description{
There are two methods - \code{"fast"}, and \code{"accurate"}. The \code{"fast"} version can
look up many thousands of points very quickly, however  when a point is near
a time zone boundary and not near a populated centre, it may return the
incorrect time zone. If accuracy is more important than speed, use
\code{method = "accurate"}.
}
\examples{
tz_lookup_coords(42, -123)
tz_lookup_coords(lat = c(48.9, 38.5, 63.1, -25), lon = c(-123.5, -110.2, -95.0, 130))
}
