% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_n.R
\name{factor_n}
\alias{factor_n}
\alias{factor_n.}
\title{Factor an integer into primes}
\usage{
factor_n(n, code = FALSE, ...)

factor_n.(n, code = FALSE, ...)
}
\arguments{
\item{n}{an integer or a polynomial}

\item{code}{return only the M2 code? (default: \code{FALSE})}

\item{...}{...}
}
\value{
a data frame with integer columns \code{prime} and
  \code{power} or \code{m2_pointer} referencing the factorization
  in M2.
}
\description{
Factor an integer into primes
}
\examples{

\dontrun{ requires Macaulay2

##### basic usage
########################################

2^2 * 3^7 * 5^2 # = 218700
factor_n(218700)
factor_n.(218700)

(df <- factor_n(218700))
df$prime
df$power
str(df)


factor_n(218700, code = TRUE)


##### other options
########################################

(integer_pointer <- m2.("218700"))
m2_name(integer_pointer)
factor_n(integer_pointer, code = TRUE)
factor_n(integer_pointer)



factor_n(3234432540)
factor_n(323443254223453)
factor_n(rpois(1, 1e4))


##### known issues
########################################

# R doesn't handle big ints well. note in the following
# the m2 code number is different than the supplied number
factor_n(32344325422364353453, code = TRUE)

# this can be circumvented by passing a string instead
factor_n("32344325422364353453", code = TRUE)

# but if the factors are large, R can't handle the parsing well
factor_n("32344325422364353453")

# here's a workaround:
factor_pointer <- factor_n.("32344325422364353453")
m2_meta(factor_pointer, "ext_str")
extract_factors <- function(pointer) {
  require(stringr)
  str <- m2_meta(pointer, "ext_str")
  str <- str_sub(str, 19, -2)
  str <- str_extract_all(str, "\\\\{[0-9]+,[0-9]+\\\\}")[[1]]
  str <- str_sub(str, 2, -2)
  str <- str_split(str, ",")
  df <- as.data.frame(t(simplify2array(str)))
  names(df) <- c("prime", "power")
  df
}
(df <- extract_factors(factor_pointer))


# using gmp (currently broken)
# factor_n("32344325422364353453", gmp = TRUE)
m2("11 * 479 * 6138607975396537")
11 * 479 * 6138607975396537

}

}
