% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_summaries.R
\name{sp.tr.summary}
\alias{sp.tr.summary}
\title{Summarize Species x Traits data frame}
\usage{
sp.tr.summary(tr_cat, sp_tr, stop_if_NA = TRUE)
}
\arguments{
\item{tr_cat}{a data frame containing three columns for each trait (rows):
\itemize{
\item \strong{trait_name}: the name of all traits as in \code{sp_tr} data
frame;
\item \strong{trait_type}: the category code for each trait as followed:
\code{N} for Nominal traits (factor variable), \code{O} for Ordinal traits
(ordered variable), \code{C} for Circular traits (integer values)(circular
traits can not be used in mFD function used to compute functional distance
but ok for summary function and function to group species into Functional
Entities), \code{Q}
for quantitative traits (numeric values), and \code{F} for
fuzzy traits (i.e. described with several values defined with several
column);
\item \strong{fuzzy_name}: name of fuzzy-coded trait to which 'sub-trait'
belongs (if trait is not fuzzy, ignored so could be trait name or NA).
\item \strong{trait_weight}: weights of each traits if the user wants to
specify a weight for each trait.
}}

\item{sp_tr}{a data frame of traits values (columns) for each species
(rows). Note that species names \strong{must be} specified in the row names.}

\item{stop_if_NA}{a logical value indicating whether the process should stop
if there is some NA in the \code{sp_tr} dataframe. If you continue with
functional analysis, we remind you that functional measures, are
sensitive to missing traits}
}
\value{
If there is no fuzzy-coded trait, a three-elements list with:
\item{tr_summary_list}{a table summarizing for each trait the
number of species per modality for non-continuous trait and min, max,
mean, median, and quartiles for continuous traits.}
\item{tr_types}{a list containing traits type.}
\item{mod_list}{a list containing modalities for all traits.}

If there is fuzzy-coded trait, a four-elements list with:
\item{tr_summary_non_fuzzy_list}{a table summarizing for each trait the
number of species per modality for non-continuous trait and min, max,
mean, median, and quartiles for continuous traits.}
\item{tr_summary_fuzzy_list}{a table summarizing for each subtrait min,
max, mean, median and quartiles}
\item{tr_types}{a list containing traits type.}
\item{mod_list}{a list containing modalities for non-continuous trait.}
}
\description{
This function computes a summary data helping to choose the type of analysis
you can do with your data. For this function to work, there must be no NA in
your \code{sp_tr} data frame.
}
\examples{
# Load Species x Traits data
data('fruits_traits', package = 'mFD')

# Load Traits x Categories data
data('fruits_traits_cat', package = 'mFD')

# Summarize Species x Traits data
mFD::sp.tr.summary(tr_cat = fruits_traits_cat, sp_tr = fruits_traits)
}
\author{
Camille Magneville and Sebastien Villeger
}
