% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RA2.R
\name{get_mean_sd_hour}
\alias{get_mean_sd_hour}
\title{get subject average of time variables}
\usage{
get_mean_sd_hour(tind, unit2minute = 60, out = c("mean", "sd"))
}
\arguments{
\item{tind}{\code{numeric} A vector of times which we want to get an average/sd for. The first two columns have to be ID and Day.}

\item{unit2minute}{\code{numeric} The ratio of the unit of time and minute. For example, the input unit is hour, the unit2minute = 60.}

\item{out}{\code{character} Specify get the mean or sd of the time variables. Default=c("mean","sd") when both mean and sd are calculated.}
}
\value{
mean and sd of the input timing
}
\description{
A function for calcualting the average timing of variables (in this case the M10 and L5).  Find the average timing mu that min{ sum { min[ (tind_i - mu)^2, (1440 + mu - tind_i )^2 ]}}
}
\examples{
x=c(1,1,1,23,23,23) 
get_mean_sd_hour(tind=x,  unit2minute=60) 
x=12+c(1,1,1,23,23,23) 
get_mean_sd_hour(tind=x,  unit2minute=60)   
x=c(1:100/5, 20+4:50/200) 
get_mean_sd_hour(tind=x,  unit2minute=60)

}
