% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagTest.R
\name{diagTest}
\alias{diagTest}
\alias{diagTest.default}
\alias{diagTest.table}
\alias{diagTest.numeric}
\title{Statistics of Diagnostic Tests}
\usage{
diagTest(x, y = NULL, p = NULL, rnd = 2, print.table = TRUE)

\method{diagTest}{default}(...)

\method{diagTest}{table}(x, y = NULL, p = NULL, rnd = 2, print.table = TRUE)

\method{diagTest}{numeric}(x, y = NULL, p = NULL, rnd = 2, print.table = TRUE)
}
\arguments{
\item{x}{a factor object or a table}

\item{y}{an optional factor object}

\item{p}{disease prevalence}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}

\item{print.table}{logical value to display formatted outputs}

\item{...}{optional arguments}
}
\description{
\code{diagTest} reports statistics of diagnostic tests
}
\details{
The screening tests are based on Bayes' Theorem. These tests help clinicians to
correctly predict the presence or absence of a particular disease from the
knowlege of test results (positive or negative) and/or the status of presenting
symptoms (present or absent) or information regarding the likelihood of positive
and negative test results and the likelihood of the presence or absence of a
particular symptom in patients with and without a particular disease.

\strong{Statistics of diagnostic tests:}

Sensitivity: True Positive (TP) rate among diseased (D+) = TP / D+

Specificity: True Negative  (TN) rate among non-diseased (D-) = TN / D-

Positive predictive value (PPV):
probability of D+ when all positives (AP) = D+ / AP

Negative predictive value (NPV):
probability of D- when all negatives (AN) = D+ / AN

Likelihood ratio (LR) = To summarize information about a diagnostic test
LR of positive result (LR+) = (Sensitivity) / (1 - Specificity)
LR of negative result (LR-) = (1 - Sensitivity) / (Specificity)

\strong{Calculating confidence intervals:}

95\% Confidence intervals were calculated by using Wilson Score Interval as
well as its continuity correction. The method was developed by Edwin Bidwell
Wilson in 1927. This interval has good properties even for a small sample.
Just lik Pearson's chi-squared test and Yates' continuity correction.

Several other methods have been developed such as Clopper–Pearson interval and
Agresti–Coull interval. But Wilson score interval methods (with or without
continuity correction) have been shown to be the most accurate and the
most robust. For further details, see references.

\strong{Reference:}
\enumerate{
\item Biostatistics A Foundation for Analysis in the Health Sciences
(10th Edition). Chapter 3.5 BAYES’ THEOREM, SCREENING TESTS, SENSITIVITY,
SPECIFICITY
\item Avijit Hazra, Nithya Gogtay. Biostatistics Series Module 7: The
Statistics of Diagnostic Tests. Indian J Dermatol. 2017 Jan-Feb; 62(1):
18-24. doi: 10.4103/0019-5154.198047
\item Brown, Lawrence D.; Cai, T. Tony; DasGupta, Anirban (2001). "Interval
Estimation for a Binomial Proportion". Statistical Science. 16 (2): 101–133.
\item Wallis, Sean A. (2013). "Binomial confidence intervals and contingency
tests: mathematical fundamentals and the evaluation of alternative methods"
.Journal of Quantitative Linguistics. 20 (3): 178–208.
\item Newcombe, R. G. (1998). "Two-sided confidence intervals for the single
proportion: comparison of seven methods". Statistics in Medicine. 17 (8):
857–872. doi:10.1002/(SICI)1097-0258(19980430)17:8<857::AID-SIM777>3.0.CO;2-E.
PMID 9595616.
}
}
\examples{


#### Biostatistics A Foundation for Analysis in the Health Sciences (10th Edition)
# numbers taken from Example 3.5.1

diagTest(as.table(matrix(c(436, 5, 14, 495), ncol = 2, byrow = TRUE)))
diagTest(as.table(matrix(c(436, 5, 14, 495), ncol = 2, byrow = TRUE)),
         p = .113)

#### Avijit Hazra, Nithya Gogtay. Biostatistics Series Module 7: The
#### Statistics of Diagnostic Tests. Indian J Dermatol. 2017 Jan-Feb; 62(1):
#### 18-24. doi: 10.4103/0019-5154.198047

diagTest(as.table(matrix(c(2, 18, 1, 182), ncol = 2, byrow = TRUE)))
diagTest(as.table(matrix(c(2, 18, 1, 182), ncol = 2, byrow = TRUE)),
         p = .10)
diagTest(as.table(matrix(c(30, 35, 23, 12), ncol = 2, byrow = TRUE)))
diagTest(as.table(matrix(c(30, 35, 23, 12), ncol = 2, byrow = TRUE)),
         p = .10)

#### Just an example to demonstrate
# diagTest(infert$case, infert$spontaneous)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
