% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leftJoin.R
\name{leftJoin}
\alias{leftJoin}
\title{Join two or more datasets}
\usage{
leftJoin(data, ..., by)
}
\arguments{
\item{data}{master dataset}

\item{...}{mergers or datasets to merge into master dataset}

\item{by}{common variables}
}
\value{
Modified dataset in \code{data.frame}
}
\description{
\code{leftJoin()} merges two or multiple datasets sharing common variables
and keeping all rows from x or master.
}
\details{
The join keeps all rows or observations in master dataset with matched
observations from mergers. It adds one more variable \code{merge_} to the resulting
dataset. The value \code{1} of \code{merge_} indicates the rows are from master dataset and
for 2, rows from merger dataset and 3 is matched observations. In leftJoin,
there can be both 1 or 3 in the return dataset.
}
\note{
For \code{tibble} data format, the return dataset from Join operation results in
\code{data.frame}since the function is based on \code{\link{merge}}.
}
\section{Displaying notes}{
The notes are displayed in a fashion to inform the user what has been joined or
not joined. This provides useful insights into one's own data. This is inspired
by \code{STATA}.
}

\examples{


## set seed
set.seed(123)
## first, create a patient dataset
patient <- data.frame(
    hospid = 1:100,
    docid = round(runif(100, 1, 15)),
    sex = runif(100, 1, 2),
    age = runif(100, 30, 60)
)

## now create a doctor dataset
doc <- data.frame(
   docid = c(1:10, 21:25),
   rating = round(runif(15, 1, 5))
)

## left join the two dataset
leftJoin(patient, doc, by = "docid")

## there are 36 records not matched, 31 not matched from master dataset,
## 5 not matched from merger dataset. 69 Final matched records


}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
