% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_oxford_grid.R
\name{plot_oxford_grid}
\alias{plot_oxford_grid}
\title{plot the Macro-synteny as an oxford grid.}
\usage{
plot_oxford_grid(
  orthologs_df,
  sp1_label = "",
  sp2_label = "",
  dot_size = 0.5,
  dot_alpha = 0.4,
  reorder = FALSE,
  keep_only_significant = FALSE,
  color_by = NULL,
  pvalue_threshold = 0.001,
  color_palette = NULL
)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded by the load_orthologs()}

\item{sp1_label}{character. name of 1st species to display on the plot}

\item{sp2_label}{character. name of 2nd species to display on the plot}

\item{dot_size}{numeric. (default = 0.5)}

\item{dot_alpha}{numeric. (default = 0.4)}

\item{reorder}{logical. (default = FALSE) tells whether to reorder the chromosomes in clusters as implemented in reorder_macrosynteny()}

\item{keep_only_significant}{logical. (default = FALSE)}

\item{color_by}{string/variable name. (default = NULL) column of the orthologs_df to use to color the dots.}

\item{pvalue_threshold}{numeric. (default = 0.001)}

\item{color_palette}{vector. (default = NULL) list of colors (as string under double quote) for the clusters. The amount of colors must match the amount of clusters.}
}
\value{
A ggplot2 object
}
\description{
This is a function to plot the oxford grided plot to compare the macro synteny of two species. Its input will have been loaded using load_orthologs()
}
\examples{
# basic usage of plot_oxford_grid : 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)

plot_oxford_grid(my_orthologs,
                 sp1_label = "B.floridae",
                 sp2_label = "P.echinospica")

# plot a reordered Oxford Grid and color by cluster :
\donttest{
plot_oxford_grid(my_orthologs,
                 sp1_label = "B.floridae",
                 sp2_label = "P.echinospica",
                 reorder = TRUE,
                 color_by = "clust")
 }
}
\seealso{
\code{\link[=load_orthologs]{load_orthologs()}}

\code{\link[=reorder_macrosynteny]{reorder_macrosynteny()}}
}
