% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{columns}
\alias{columns}
\alias{cols}
\alias{rows}
\title{Selects columns or rows from the data set}
\usage{
columns(data, ...)

cols(data, ...)

rows(data, ...)
}
\arguments{
\item{data}{data.table/data.frame}

\item{...}{unquoted or quoted column names, regex selectors or variable
ranges for 'columns' and logical conditions for 'rows'.}
}
\value{
data.frame/data.table
}
\description{
\itemize{
\item \code{columns}: select columns from dataset. There are four ways of column selection:
}
\enumerate{
\item Simply by column names
\item By variable ranges, e. g. vs:carb. Alternatively, you can use '\%to\%'
instead of colon: 'vs \%to\% carb'.
\item With regular expressions. Characters which start with '^' or end with '$'
considered as Perl-style regular expression patterns. For example, '^Petal'
returns all variables started with 'Petal'. 'Width$' returns all variables
which end with 'Width'. Pattern '^.' matches all variables and pattern
'^.*my_str' is equivalent to contains "my_str"'.
\item By character variables with interpolated parts. Expression in the curly
brackets inside characters will be evaluated in the parent frame with
\link{text_expand}. For example, \verb{a\{1:3\}} will be transformed to the names 'a1',
'a2', 'a3'. 'cols' is just a shortcut for 'columns'. See examples.
}\preformatted{}
\itemize{
\item \code{rows}: select rows from dataset by logical conditions.
}
}
\examples{

## columns
mtcars \%>\%
    columns(vs:carb, cyl)
mtcars \%>\%
    columns(-am, -cyl)

# regular expression pattern
columns(iris, "^Petal") \%>\% head() # variables which start from 'Petal'
columns(iris, "Width$") \%>\% head() # variables which end with 'Width'
# move Species variable to the front.
# pattern "^." matches all variables
columns(iris, Species, "^.") \%>\% head()
# pattern "^.*i" means "contains 'i'"
columns(iris, "^.*i") \%>\% head()
# numeric indexing - all variables except Species
columns(iris, 1:4) \%>\% head()

# variable expansion
dims = c("Width", "Length")
columns(iris, "Petal.{dims}") \%>\% head()

# rows

mtcars \%>\%
    rows(am==0) \%>\%
    head()

# select rows with compound condition
mtcars \%>\%
    rows(am==0 & mpg>mean(mpg))

}
