% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolSubtypeSelect.R
\name{toolSubtypeSelect}
\alias{toolSubtypeSelect}
\title{Tool: SubtypeSelect}
\usage{
toolSubtypeSelect(subtype, files)
}
\arguments{
\item{subtype}{A chosen subtype (character)}

\item{files}{A named vector. The names of the vector correspond to the
allowed subtypes and the content of the vector are the corresponding file
names.}
}
\value{
The file name corresponding to the given subtype
}
\description{
This function is a support function for the selection of a subtype in a
readX function. In addition to the subtype selection it also performs some
consistency checks.
}
\examples{


subtype <- "extent"

files <-  c(protection="protection.csv",
              production="production.csv",
              extent="forest_extent.csv")
\dontrun{
file <- toolSubtypeSelect(subtype,files)
}
}
\seealso{
\code{\link{readSource}}
}
\author{
Jan Philipp Dietrich
}
