% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.species.code.definitions.R
\name{check.species.code.definitions}
\alias{check.species.code.definitions}
\title{Checks the list of species code definitions supplied by the user}
\usage{
check.species.code.definitions(species.code.definitions, species.name)
}
\arguments{
\item{species.code.definitions}{a list with an element for each 
unidentified code which contains a vector of corresponding identified 
species codes or NULL if not required}

\item{species.name}{a vector of species names for which model names were 
supplied in the ddf.models list passed to execute.multi.analysis by the 
user.}
}
\value{
updated species.code.definitions list
}
\description{
Firstly, it checks that there are not multiple definitions for the same species code.
Secondly, it checks that the names of the ddf models correspond to the names 
in the species code definitions. Lastly, it checks that definitions are 
provided for all species codes and if not it adds the missing definitions 
assuming they correspond to identified categories
}
\note{
Internal function not intended to be called by user.
}
\seealso{
\code{execute.multi.analysis}
}
\author{
Laura Marshall
}
\keyword{internal}
