% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-catalogue_functions.R
\name{valueType_self_adjust}
\alias{valueType_self_adjust}
\title{Guess and attribute the valueType of a data dictionary or dataset variable}
\usage{
valueType_self_adjust(...)
}
\arguments{
\item{...}{Object that can be either a dataset or a data dictionary.}
}
\value{
Either a tibble, identifying the dataset, or a list of tibble(s)
identifying a data dictionary, depending which the input refers to.
}
\description{
Determines the valueType of an object based on \code{base::typeof()} and
`base::class().
The possible values returned are 'date', 'boolean', 'integer', 'decimal', and
'text'.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

###### Example : The valueType of a dataset can be adjusted. each column is
# evaluated as whole, and the best valueType match found is applied. If 
# there is no better match found, the column is left as it is.

valueType_self_adjust(mtcars['cyl'])

}

}
\seealso{
\code{\link[=valueType_adjust]{valueType_adjust()}}
}
