% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{as_category}
\alias{as_category}
\title{Validate and coerce any object as a categorical variable.}
\usage{
as_category(x)
}
\arguments{
\item{x}{A vector object to be coerced to categorical.}
}
\value{
A vector with class haven_labelled.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Converts a vector object to a categorical object, typically a column in a
data frame. The categories come from non-missing values present in the
object and are added to an associated data dictionary (when present).
}
\examples{
{

library(dplyr)
mtcars <- tibble(mtcars)
as_category(mtcars[['cyl']])

head(mtcars \%>\% mutate(cyl = as_category(cyl)))


}

}
\seealso{
\code{\link[haven:labelled]{haven::labelled()}}
}
