% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{as_dataset}
\alias{as_dataset}
\title{Validate and coerce any object as a dataset}
\usage{
as_dataset(object, col_id = NULL)
}
\arguments{
\item{object}{A potential dataset object to be coerced.}

\item{col_id}{An optional character string specifying the name(s) or
position(s) of the column(s) used as identifiers.}
}
\value{
A data frame with \code{madshapR::class} 'dataset'.
}
\description{
Checks if an object is a valid dataset and returns it with the appropriate
\code{madshapR::class} attribute. This function mainly helps validate inputs
within other functions of the package but could be used separately to check
if a dataset is valid.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

###### Example 1: A dataset can have an id column specified as an attribute. 
dataset <- as_dataset(madshapR_DEMO$dataset_MELBOURNE, col_id = "id")
glimpse(dataset)

###### Example 2: Any data frame can be a dataset by definition.
glimpse(as_dataset(iris, col_id = "Species"))

}

}
