% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateMetadata.R
\name{updateMetadata}
\alias{updateMetadata}
\title{updateMetadata (!experimental!)}
\usage{
updateMetadata(
  x,
  y = NULL,
  unit = ifelse(is.null(y), "keep", "update"),
  source = ifelse(is.null(y), "keep", "merge"),
  calcHistory = ifelse(is.null(y), "keep", "update"),
  user = "update",
  date = "update",
  description = ifelse(is.null(y), "keep", "merge"),
  note = ifelse(is.null(y), "keep", "merge"),
  version = ifelse(is.null(y), "keep", "merge"),
  n = 1,
  cH_priority = 2
)
}
\arguments{
\item{x}{MAgPIE object to be updated}

\item{y}{MAgPIE object to copy Metadata from (optional)}

\item{unit}{An object of type units indicating the units of measure of the MAgPIE data. 
Possible arguments are: 
- "keep": maintains the unit field in x
- "copy": copies the unit field of y to x
- "clear": deletes the unit field from x
- "update": if units of x do not match units of y, sets units to "mixed". Else, copies units of y to x.
- string or vector specifying new units for x
The default argument is "keep" if no y argument is provided, or "update" if y is provided.}

\item{source}{An object of class Bibtex (or a list of Bibtex objects) indicating the source(s) of the 
input data in BibTeX style. Possible arguments are "keep", "clear", "copy" (which overwrites the source(s) 
of x with the source(s) of y), "merge" (which combines the sources of x and y in a list), or a new source 
can be entered here as a Bibtex object. By default, "keep" if no y argument, or "merge" if y is provided.}

\item{calcHistory}{A tree-like object of class Node indicating the functions through which x has passed. 
Possible arguments are "keep", "copy", "clear", "merge" (which combines the history trees of 2 or more 
objects), and "update" (which adds the function presently calling updateMetadata (or a function further 
upstream if specified by n) to calcHistory and also merges if y is provided). A node object can also be 
provided which will overwrite any existing value. Finally, if a character of length one is provided, the
behavior will be like "update" using the string as the new root node. By default, "keep" if no y argument,
or "merge" if y is provided.}

\item{user}{A string indicating the user who last modified the MAgPIE object. Possible arguments are "keep",
"copy", "update" (which retrieves the username currently logged into the system), or a character string 
which specifies a new user. "update" by default.}

\item{date}{A character indicating the MAgPIE object's last modified date. Possible arguments are 
"keep", "copy", and "update" (which sets the date of x to the current time). "update" by default.}

\item{description}{A string or list of strings containing a description of the dataset. Possible arguments are 
"keep", "copy", "merge", "clear", or a new description can be defined here by a character string. By default, 
"keep" if no y argument, or "copy" if y is provided.}

\item{note}{A string or list of strings for attaching notes (e.g. instructions, warnings, etc.) to the data.
Possible arguments are "keep", "copy", "merge", clear", or a new note can be entered here as a character string. 
By default, "keep" if no y argument, or "copy" if y is provided.}

\item{version}{A named vector containing the name(s) and version number(s) of the software used. Possible 
arguments are "keep" (default), "copy", "merge", "clear", or a character vector (package names and numbers 
can be provided as a named vector, in concatenated strings with a space separating name & number, or in a 
single string with a ';' separating each package).}

\item{n}{If calcHistory is to be updated, this integer indicates how many frames ahead in the stack to 
find the function to append to the the object's calcHistory. n=1 by default.}

\item{cH_priority}{Integer to set the significance of the function call with respect to calcHistory tracking 
(lower = more significant). To be compared against the "calcHistory_verbosity" global option (user can set this 
via withMetadata).}
}
\value{
updateMetadata returns the magpie object x with metadata modified as desired.
}
\description{
This function is currently experimental and non-functional by default! To activate it,
set withMetadata(TRUE), otherwise it will not return or modify any metadata!
}
\details{
This function is to be used by other functions to update metadata for magclass objects 

When an operation is performed on a MAgPIE dataset, updateMetadata can be used to copy 
Metadata entries to the new MAgPIE object or update the Metadata fields appropriately.  
fields of "unit", "source", "date", "user" and "calcHistory", 
contained in a list.

The "source" component should include all information about the source(s)
where the data was originally reported. Specifically, the authors,
publication date, article title, journal
}
\seealso{
\code{\link{getComment}}, \code{\link{getMetadata}}, \code{\link{getNames}},
\code{\link{getYears}}, \code{\link{getCPR}}, \code{\link{read.magpie}},
\code{\link{write.magpie}}, \code{"\linkS4class{magpie}"}
}
\author{
Stephen Bi
}
