#' Magick Image Processing
#'
#' The `magick` package for graphics and image processing in R. Important resources:
#' - [R introduction vignette](https://bit.ly/magickintro): getting started
#' - [Magick++ API](https://www.imagemagick.org/Magick++/Image++.html) and
#'     [Magick++ STL](https://www.imagemagick.org/Magick++/STL.html) detailed descriptions of methods and parameters
#'
#' Documentation is split into the following pages:
#' - [analysis] - metrics and calculations: `compare`, `fft`
#' - [animation] - manipulate or combine multiple frames: `animate`,
#'  `morph`, `mosaic`, `montage`, `average`, `append`, `apply`
#' - [attributes] - image properties: `comment`, `info`
#' - [color] - contrast, brightness, colors: `modulate`, `quantize`, `map`, `transparent`,
#'  `background`, `colorize`, `contrast`, `normalize`, `enhance`, `equalize`, `median`
#' - [composite] - advanced joining: `composite`, `border`, `frame`
#' - [device] - creating graphics and drawing on images
#' - [editing] - basice image IO: `read`, `write`, `convert`, `join`, `display`, `brose`
#' - [effects] - fun effects: `despecle`, `reducenoise`, `noise`, `blur`, `charcoal`,
#'   `edge`, `oilpaint`, `emboss`, `implode`, `negate`
#' - [ocr] - extract text from image using [tesseract][tesseract::tesseract] package
#' - [painting] - flood fill and annotating text
#' - [transform] - shape operations: `trim`, `chop`, `rotate`, `resize`, `scale`, `sample`
#'   `crop`, `flip`, `flop`, `deskew`, `page`
#'
#' @name index
#' @rdname magick
#' @family image
#' @aliases magick magick-package imagemagick
NULL
