% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/inferGraph.R
\docType{methods}
\name{inferGraph}
\alias{inferGraph}
\alias{inferGraph,character-method}
\alias{inferGraph,language-method}
\alias{inferGraph,expression-method}
\title{Infer Task Dependency Graph}
\usage{
inferGraph(code, ...)

\S4method{inferGraph}{character}(code, ...)

\S4method{inferGraph}{language}(code, ...)

\S4method{inferGraph}{expression}(code, ...)
}
\arguments{
\item{code}{the file path to a script or an object that can be coerced
to an expression.}

\item{...}{additional arguments to methods}
}
\value{
object of class \linkS4class{DependGraph}
}
\description{
Statically analyze code to determine implicit dependencies
}
\examples{
g <- inferGraph(parse(text = "
  a <- 1
  b <- 2
  c <- a + b
  d <- b * c
"))

ig <- as(g, "igraph")
plot(ig)
}
