# WARNING - Generated by {fusen} from dev/import-data.Rmd: do not edit by hand

dummy_multiple_paths_valid <- system.file(
  c("biotyper.csv", "biotyper.csv", "biotyper.csv"),
  package = "maldipickr"
)
dummy_multiple_paths_with_one_empty <- system.file(
  c("biotyper.csv", "biotyper_empty.csv", "biotyper.csv"),
  package = "maldipickr"
)
test_that("read_many_biotyper_reports works with all valid", {
  expect_no_warning(
    out <- read_many_biotyper_reports(
      dummy_multiple_paths_valid,
      report_ids = c("first", "second", "third")
    )
  )
  expect_equal(
    dim(out), c(9, 9) # rows cols
  )
  expect_true( # The second report should be present
    any(grepl("second", out$name))
  )
})
test_that("read_many_biotyper_reports skips empty report with warning", {
  expect_warning(
    out <- read_many_biotyper_reports(
      dummy_multiple_paths_with_one_empty,
      report_ids = c("first", "second", "third")
    ),
    "Remove"
  )
  expect_equal(
    dim(out), c(6, 9) # rows cols
  )
  expect_false( # The second report should be dropped
    any(grepl("second", out$name))
  )
})
test_that("read_many_biotyper_reports works with arguments passed to mutate", {
  expect_equal(
    read_many_biotyper_reports(
      dummy_multiple_paths_valid,
      report_ids = c("first", "second", "third"),
      growth_temperature = 37.0
    ) %>%
      dplyr::pull(growth_temperature) %>% unique(), 37
  )
})
