/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArrayInitializer;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHArrayDimensions
extends SimpleNode {
    public Class baseType;
    private int arrayDims;
    public int[] dimensions;

    BSHArrayDimensions(int n) {
        super(n);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    public Object eval(Class clazz, CallStack callStack, Interpreter interpreter) throws EvalError {
        Interpreter.debug("array base type = " + clazz);
        this.baseType = clazz;
        return this.eval(callStack, interpreter);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        if (simpleNode instanceof BSHArrayInitializer) {
            if (this.baseType == null) {
                throw new EvalError("Internal Array Eval err:  unknown base type", this);
            }
            Object object = ((BSHArrayInitializer)simpleNode).eval(this.baseType, this.arrayDims, callStack, interpreter);
            Class<?> clazz = object.getClass();
            this.dimensions = new int[Reflect.getArrayDimensions(clazz)];
            if (this.dimensions.length != this.arrayDims) {
                throw new EvalError("Incompatible initializer. Allocation calls for a " + this.arrayDims + " dimensional array, but initializer is a " + this.dimensions.length + " dimensional array", this);
            }
            Object object2 = object;
            int n = 0;
            while (n < this.dimensions.length) {
                this.dimensions[n] = Array.getLength(object2);
                if (this.dimensions[n] > 0) {
                    object2 = Array.get(object2, 0);
                }
                ++n;
            }
            return object;
        }
        this.dimensions = new int[this.jjtGetNumChildren()];
        int n = 0;
        while (n < this.dimensions.length) {
            try {
                Object object = ((SimpleNode)this.jjtGetChild(n)).eval(callStack, interpreter);
                this.dimensions[n] = ((Primitive)object).intValue();
            }
            catch (Exception exception) {
                throw new EvalError("Array index: " + n + " does not evaluate to an integer", this);
            }
            ++n;
        }
        return Primitive.VOID;
    }
}

