/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.BitSet;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.DictionaryElementType;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.data.Word;

public class Synset
extends PointerTarget
implements DictionaryElement {
    static final long serialVersionUID = 4038955719653496529L;
    private POS _pos;
    private Pointer[] _pointers;
    private long _offset;
    private Word[] _words;
    private String _gloss;
    private BitSet _verbFrameFlags;
    private boolean _isAdjectiveCluster;
    private transient String _cachedToString = null;

    public Synset(POS pos, long offset, Word[] words, Pointer[] pointers, String gloss, BitSet verbFrames) {
        this(pos, offset, words, pointers, gloss, verbFrames, false);
    }

    public Synset(POS pos, long offset, Word[] words, Pointer[] pointers, String gloss, BitSet verbFrames, boolean isAdjectiveCluster) {
        this._pos = pos;
        this._pointers = pointers;
        this._offset = offset;
        this._words = words;
        this._gloss = gloss;
        this._verbFrameFlags = verbFrames;
        this._isAdjectiveCluster = isAdjectiveCluster;
    }

    public DictionaryElementType getType() {
        return DictionaryElementType.SYNSET;
    }

    public boolean equals(Object object) {
        return object instanceof Synset && ((Synset)object).getPOS().equals(this.getPOS()) && ((Synset)object).getOffset() == this.getOffset();
    }

    public int hashCode() {
        return this.getPOS().hashCode() ^ (int)this.getOffset();
    }

    public String toString() {
        if (this._cachedToString == null) {
            StringBuffer words = new StringBuffer();
            for (int i = 0; i < this.getWordsSize(); ++i) {
                if (i > 0) {
                    words.append(", ");
                }
                words.append(this.getWord(i).getLemma());
            }
            if (this.getGloss() != null) {
                words.append(" -- (" + this.getGloss() + ")");
            }
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_009", new Object[]{new Long(this.getOffset()), this.getPOS(), words.toString()});
        }
        return this._cachedToString;
    }

    public POS getPOS() {
        return this._pos;
    }

    public Pointer[] getPointers() {
        return this._pointers;
    }

    public String getGloss() {
        return this._gloss;
    }

    public Word[] getWords() {
        return this._words;
    }

    public int getWordsSize() {
        return this.getWords().length;
    }

    public Word getWord(int index) {
        return this._words[index];
    }

    public long getOffset() {
        return this._offset;
    }

    public Object getKey() {
        return new Long(this.getOffset());
    }

    public boolean isAdjectiveCluster() {
        return this._isAdjectiveCluster;
    }

    public String[] getVerbFrames() {
        return VerbFrame.getFrames(this._verbFrameFlags);
    }

    public BitSet getVerbFrameFlags() {
        return this._verbFrameFlags;
    }

    public int[] getVerbFrameIndicies() {
        return VerbFrame.getVerbFrameIndicies(this._verbFrameFlags);
    }

    public boolean containsWord(String lemma) {
        for (int i = 0; i < this.getWordsSize(); ++i) {
            if (!this.getWord(i).getLemma().equals(lemma)) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._pos = POS.getPOSForKey(this._pos.getKey());
    }
}

