/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.DatabaseDictionaryElementFactory;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.POSKey;
import net.didion.jwnl.dictionary.database.DatabaseManager;
import net.didion.jwnl.dictionary.database.Query;
import net.didion.jwnl.util.factory.Param;

public class DatabaseBackedDictionary
extends AbstractCachingDictionary {
    public static final String MORPH = "morphological_processor";
    public static final String DICTIONARY_ELEMENT_FACTORY = "dictionary_element_factory";
    public static final String DATABASE_MANAGER = "database_manager";
    private DatabaseDictionaryElementFactory _elementFactory;
    private DatabaseManager _dbManager;

    public DatabaseBackedDictionary() {
    }

    private DatabaseBackedDictionary(MorphologicalProcessor morph, DatabaseDictionaryElementFactory elementFactory, DatabaseManager dbManager) {
        super(morph);
        this._elementFactory = elementFactory;
        this._dbManager = dbManager;
    }

    public void install(Map params) throws JWNLException {
        Param param = (Param)params.get(MORPH);
        MorphologicalProcessor morph = param == null ? null : (MorphologicalProcessor)param.create();
        param = (Param)params.get(DICTIONARY_ELEMENT_FACTORY);
        DatabaseDictionaryElementFactory factory = param == null ? null : (DatabaseDictionaryElementFactory)param.create();
        param = (Param)params.get(DATABASE_MANAGER);
        DatabaseManager manager = param == null ? null : (DatabaseManager)param.create();
        DatabaseBackedDictionary.setDictionary(new DatabaseBackedDictionary(morph, factory, manager));
    }

    public IndexWord getIndexWord(POS pos, String lemma) throws JWNLException {
        lemma = DatabaseBackedDictionary.prepareQueryString(lemma);
        IndexWord word = null;
        if (lemma.length() > 0) {
            if (this.isCachingEnabled()) {
                word = this.getCachedIndexWord(new POSKey(pos, lemma));
            }
            if (word == null) {
                Query query = null;
                try {
                    query = this._dbManager.getIndexWordSynsetsQuery(pos, lemma);
                    word = this._elementFactory.createIndexWord(pos, lemma, query.execute());
                    if (word != null && this.isCachingEnabled()) {
                        this.cacheIndexWord(new POSKey(pos, lemma), word);
                    }
                }
                catch (SQLException e) {
                    throw new JWNLException("DICTIONARY_EXCEPTION_023", e);
                }
                finally {
                    query.close();
                }
            }
        }
        return word;
    }

    public Iterator getIndexWordIterator(POS pos) throws JWNLException {
        Query query = this._dbManager.getIndexWordLemmasQuery(pos);
        return new IndexWordIterator(pos, query);
    }

    public Iterator getIndexWordIterator(POS pos, String substring) throws JWNLException {
        Query query = this._dbManager.getIndexWordLemmasQuery(pos, substring);
        return new IndexWordIterator(pos, query);
    }

    public IndexWord getRandomIndexWord(POS pos) throws JWNLException {
        Query query = this._dbManager.getRandomIndexWordQuery(pos);
        String lemma = null;
        try {
            query.execute();
            query.getResults().next();
            lemma = query.getResults().getString(1);
        }
        catch (SQLException ex) {
            throw new JWNLException("DICTIONARY_EXCEPTION_023", ex);
        }
        finally {
            query.close();
        }
        return this.getIndexWord(pos, lemma);
    }

    public Synset getSynsetAt(POS pos, long offset) throws JWNLException {
        Synset synset = null;
        if (this.isCachingEnabled()) {
            synset = this.getCachedSynset(new POSKey(pos, offset));
        }
        if (synset == null) {
            Query query = null;
            Query wordQuery = null;
            Query pointerQuery = null;
            Query verbFrameQuery = null;
            try {
                block6: {
                    try {
                        query = this._dbManager.getSynsetQuery(pos, offset);
                        wordQuery = this._dbManager.getSynsetWordQuery(pos, offset);
                        pointerQuery = this._dbManager.getPointerQuery(pos, offset);
                        verbFrameQuery = this._dbManager.getVerbFrameQuery(pos, offset);
                        synset = this._elementFactory.createSynset(pos, offset, query.execute(), wordQuery.execute(), pointerQuery.execute(), verbFrameQuery.execute());
                        if (synset == null || !this.isCachingEnabled()) break block6;
                        this.cacheSynset(new POSKey(pos, offset), synset);
                    }
                    catch (SQLException e) {
                        throw new JWNLException("DICTIONARY_EXCEPTION_023", e);
                    }
                }
                Object var11_8 = null;
                query.close();
                wordQuery.close();
                pointerQuery.close();
                verbFrameQuery.close();
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                query.close();
                wordQuery.close();
                pointerQuery.close();
                verbFrameQuery.close();
                throw throwable;
            }
        }
        return synset;
    }

    public Iterator getSynsetIterator(POS pos) throws JWNLException {
        Query query = this._dbManager.getSynsetsQuery(pos);
        return new SynsetIterator(pos, query);
    }

    public Exc getException(POS pos, String derivation) throws JWNLException {
        Exc exc = null;
        if (this.isCachingEnabled()) {
            exc = this.getCachedException(new POSKey(pos, derivation));
        }
        if (exc == null) {
            Query query = null;
            try {
                query = this._dbManager.getExceptionQuery(pos, derivation);
                exc = this._elementFactory.createExc(pos, derivation, query.execute());
                if (exc != null && this.isCachingEnabled()) {
                    this.cacheException(new POSKey(pos, derivation), exc);
                }
            }
            catch (SQLException e) {
                throw new JWNLException("DICTIONARY_EXCEPTION_023", e);
            }
            finally {
                query.close();
            }
        }
        return exc;
    }

    public Iterator getExceptionIterator(POS pos) throws JWNLException {
        Query query = this._dbManager.getExceptionsQuery(pos);
        return new ExceptionIterator(pos, query);
    }

    public void close() {
    }

    private class ExceptionIterator
    extends DatabaseElementIterator {
        public ExceptionIterator(POS pos, Query query) {
            super(pos, query);
        }

        protected DictionaryElement createElement() throws Exception {
            String derivation = this.getResults().getString(1);
            return DatabaseBackedDictionary.this.getException(this.getPOS(), derivation);
        }
    }

    private class SynsetIterator
    extends DatabaseElementIterator {
        public SynsetIterator(POS pos, Query query) {
            super(pos, query);
        }

        protected DictionaryElement createElement() throws Exception {
            long offset = this.getResults().getLong(1);
            return DatabaseBackedDictionary.this.getSynsetAt(this.getPOS(), offset);
        }
    }

    private class IndexWordIterator
    extends DatabaseElementIterator {
        public IndexWordIterator(POS pos, Query query) {
            super(pos, query);
        }

        protected DictionaryElement createElement() throws Exception {
            String lemma = this.getResults().getString(1);
            return DatabaseBackedDictionary.this.getIndexWord(this.getPOS(), lemma);
        }
    }

    private abstract class DatabaseElementIterator
    implements Iterator {
        private POS _pos;
        private Query _lemmas;
        private boolean _advanced = false;
        private boolean _hasNext = false;

        protected DatabaseElementIterator(POS pos, Query query) {
            this._pos = pos;
            this._lemmas = query;
        }

        public boolean hasNext() {
            if (!this._advanced) {
                this._advanced = true;
                try {
                    this._hasNext = this.getResults().next();
                }
                catch (SQLException e) {
                    this._hasNext = false;
                }
            }
            if (!this._hasNext) {
                this._lemmas.close();
            }
            return this._hasNext;
        }

        public Object next() {
            if (this.hasNext()) {
                this._advanced = false;
                try {
                    return this.createElement();
                }
                catch (Exception e) {
                    return null;
                }
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract DictionaryElement createElement() throws Exception;

        protected POS getPOS() {
            return this._pos;
        }

        protected ResultSet getResults() throws SQLException {
            if (!this._lemmas.isExecuted()) {
                this._lemmas.execute();
            }
            return this._lemmas.getResults();
        }

        protected void finalize() throws Throwable {
            this._lemmas.close();
        }
    }
}

