/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.drawing;

import salvo.jesus.graph.DirectedEdge;
import salvo.jesus.graph.DirectedWeightedEdge;
import salvo.jesus.graph.WeightedEdge;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraphComponent;
import salvo.jesus.graph.visual.drawing.Painter;
import salvo.jesus.graph.visual.drawing.VisualDirectedEdgePainterImpl;
import salvo.jesus.graph.visual.drawing.VisualDirectedWeightedEdgePainterImpl;
import salvo.jesus.graph.visual.drawing.VisualEdgePainterFactory;
import salvo.jesus.graph.visual.drawing.VisualEdgePainterImpl;
import salvo.jesus.graph.visual.drawing.VisualWeightedEdgePainterImpl;

public final class VisualEdgePainterFactoryImpl
extends VisualEdgePainterFactory {
    private static VisualEdgePainterFactoryImpl thisInstance;
    private VisualEdgePainterImpl basicPainter;
    private VisualDirectedEdgePainterImpl directedEdgePainter;
    private VisualWeightedEdgePainterImpl weightedEdgePainter;
    private VisualDirectedWeightedEdgePainterImpl directedWeightedEdgePainter;

    private VisualEdgePainterFactoryImpl() {
    }

    public static VisualEdgePainterFactoryImpl getInstance() {
        if (thisInstance == null) {
            thisInstance = new VisualEdgePainterFactoryImpl();
        }
        return thisInstance;
    }

    public Painter getPainter(VisualGraphComponent component) {
        VisualEdge ve = (VisualEdge)component;
        if (ve.getEdge() instanceof DirectedWeightedEdge) {
            if (this.directedWeightedEdgePainter == null) {
                this.directedWeightedEdgePainter = new VisualDirectedWeightedEdgePainterImpl();
            }
            return this.directedWeightedEdgePainter;
        }
        if (ve.getEdge() instanceof WeightedEdge) {
            if (this.weightedEdgePainter == null) {
                this.weightedEdgePainter = new VisualWeightedEdgePainterImpl();
            }
            return this.weightedEdgePainter;
        }
        if (ve.getEdge() instanceof DirectedEdge) {
            if (this.directedEdgePainter == null) {
                this.directedEdgePainter = new VisualDirectedEdgePainterImpl();
            }
            return this.directedEdgePainter;
        }
        if (this.basicPainter == null) {
            this.basicPainter = new VisualEdgePainterImpl();
        }
        return this.basicPainter;
    }
}

