/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.Alphabet;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestAlphabet
extends TestCase {
    public TestAlphabet(String name) {
        super(name);
    }

    public void testNotFound() {
        Alphabet dict = new Alphabet();
        dict.lookupIndex("TEST1");
        dict.lookupIndex("TEST2");
        dict.lookupIndex("TEST3");
        TestAlphabet.assertEquals((int)-1, (int)dict.lookupIndex("TEST4", false));
        TestAlphabet.assertEquals((int)3, (int)dict.size());
        TestAlphabet.assertEquals((int)3, (int)dict.lookupIndex("TEST4", true));
    }

    public void testReadResolve() throws IOException, ClassNotFoundException {
        Alphabet dict = new Alphabet();
        dict.lookupIndex("TEST1");
        dict.lookupIndex("TEST2");
        dict.lookupIndex("TEST3");
        Alphabet dict2 = (Alphabet)TestSerializable.cloneViaSerialization(dict);
        TestAlphabet.assertTrue((dict == dict2 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestAlphabet.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestAlphabet(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestAlphabet.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

