% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{atlastable}
\alias{atlastable}
\alias{print.atlastable}
\title{Result report with atlas data}
\usage{
atlastable(x, y, atlasdataset = NULL, ROIids = NULL, ...)

\method{print}{atlastable}(x, ...)
}
\arguments{
\item{x}{an array for the atlas image.}

\item{y}{an array for the result image.}

\item{atlasdataset}{a matrix or data.frame. The colnames should include "ROIid" and "ROIname".}

\item{ROIids}{a vector indicating ROI id shown in the result.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function refers to the results obtained by the analysis in an atlas image, and reports a summary of the results for each anatomical region.
}
\details{
\code{atlastable} requires the atlas image and data frame including the ROI id and the name.
}
\examples{
data(diffimg)
data(atlasdatasets)
data(atlas)
atlasname = "aal"
atlasdataset = atlasdatasets[[atlasname]]
tmpatlas = atlas[[atlasname]]
atlastable(tmpatlas, diffimg, atlasdataset=atlasdataset, ROIids = c(1:2, 37:40))
}
\concept{print}
