% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General.R
\name{frechetMedian}
\alias{frechetMedian}
\alias{frechetMedian.default}
\title{Calculate the Fréchet median}
\usage{
frechetMedian(mfd, X, ...)

\method{frechetMedian}{default}(
  mfd,
  X,
  mu0,
  weight = NULL,
  tol = 1e-09,
  maxit = 1000,
  alpha = 1,
  ...
)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{X}{A matrix with each column being a point on the manifold.}

\item{...}{Passed into specific methods}

\item{mu0}{A matrix of starting points. Each column corresponds to a starting point. If there are multiple columns, then a multistart algorithm is used.}

\item{weight}{A vector of weights for the observations}

\item{tol}{The threshold for determining convergence}

\item{maxit}{Maximum iteration}

\item{alpha}{The step size parameter. See Fletcher et al. (2008) CVPR}
}
\value{
A matrix with 1 column containing the Fréchet median
}
\description{
Calculate the Fréchet median
}
\section{Methods (by class)}{
\itemize{
\item \code{frechetMedian(default)}: Default method

}}
